<?php 
/**
 * Data_belum_bayar Page Controller
 * @category  Controller
 */
class Data_belum_bayarController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "data_belum_bayar";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("NOP", 
			"NAMA_WP", 
			"LETAK_OP", 
			"TAHUN_PAJAK", 
			"KETETAPAN", 
			"KOLEKTOR", 
			"CAT_BBAYAR");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				data_belum_bayar.NOP LIKE ? OR 
				data_belum_bayar.NAMA_WP LIKE ? OR 
				data_belum_bayar.LETAK_OP LIKE ? OR 
				data_belum_bayar.TAHUN_PAJAK LIKE ? OR 
				data_belum_bayar.KETETAPAN LIKE ? OR 
				data_belum_bayar.KOLEKTOR LIKE ? OR 
				data_belum_bayar.BELUM_BAYAR LIKE ? OR 
				data_belum_bayar.CAT_BBAYAR LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "data_belum_bayar/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("NOP", "ASC");
		}
		$allowed_roles = array ('administrator');
		if(!in_array(strtolower(USER_ROLE), $allowed_roles)){
		$db->where("data_belum_bayar.KOLEKTOR", get_active_user('USER') );
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Data Belum Bayar";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$this->render_view("data_belum_bayar/list.php", $data); //render the full page
	}
// No View Function Generated Because No Field is Defined as the Primary Key on the Database Table
}
