<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("dhkap/add");
$can_edit = ACL::is_allowed("dhkap/edit");
$can_view = ACL::is_allowed("dhkap/view");
$can_delete = ACL::is_allowed("dhkap/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col-sm-8 ">
                    <h4 class="record-title">TANDA TERIMA PEMBAYARAN</h4>
                </div>
                <div class="col-md-4 comp-grid">
                    <a  class="btn btn-danger" href="<?php print_link("input/list") ?>">
                        KELUAR 
                    </a>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id']) ? urlencode($data['id']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-NOP">
                                        <th class="title"> Nop: </th>
                                        <td class="value">
                                            <span  data-value="<?php echo $data['NOP']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="NOP" 
                                                data-title="Enter Nop" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['NOP']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-NAMA_WP">
                                        <th class="title"> Nama Wp: </th>
                                        <td class="value">
                                            <span  data-value="<?php echo $data['NAMA_WP']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="NAMA_WP" 
                                                data-title="Enter Nama Wp" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['NAMA_WP']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-LETAK_OP">
                                        <th class="title"> Letak Op: </th>
                                        <td class="value">
                                            <span  data-value="<?php echo $data['LETAK_OP']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="LETAK_OP" 
                                                data-title="Enter Letak Op" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['LETAK_OP']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-TAHUN_PAJAK">
                                        <th class="title"> Tahun Pajak: </th>
                                        <td class="value">
                                            <span  data-value="<?php echo $data['TAHUN_PAJAK']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="TAHUN_PAJAK" 
                                                data-title="Enter Tahun Pajak" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['TAHUN_PAJAK']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-KETETAPAN">
                                        <th class="title"> Ketetapan: </th>
                                        <td class="value">
                                            <span  data-step="0.1" 
                                                data-value="<?php echo $data['KETETAPAN']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="KETETAPAN" 
                                                data-title="Enter Ketetapan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="number" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo"Rp. " .number_format($data['KETETAPAN']); ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-KOLEKTOR">
                                        <th class="title"> Kolektor: </th>
                                        <td class="value">
                                            <span  data-source='<?php print_link('api/json/dhkap_KOLEKTOR_option_list'); ?>' 
                                                data-value="<?php echo $data['KOLEKTOR']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="KOLEKTOR" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['KOLEKTOR']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-TGL_BAYAR">
                                        <th class="title"> Tgl Bayar: </th>
                                        <td class="value">
                                            <span  data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['TGL_BAYAR']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="TGL_BAYAR" 
                                                data-title="Enter Tgl Bayar" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['TGL_BAYAR']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-KET_BAYAR">
                                        <th class="title"> Ket Bayar: </th>
                                        <td class="value">
                                            <span  data-source='<?php print_link('api/json/dhkap_KET_BAYAR_option_list'); ?>' 
                                                data-value="<?php echo $data['KET_BAYAR']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="KET_BAYAR" 
                                                data-title="Enter Ket Bayar" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="radiolist" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['KET_BAYAR']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-KETERANGAN">
                                        <th class="title"> Keterangan: </th>
                                        <td class="value">
                                            <span  data-source='<?php print_link('api/json/dhkap_KETERANGAN_option_list'); ?>' 
                                                data-value="<?php echo $data['KETERANGAN']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("dhkap/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="KETERANGAN" 
                                                data-title="Enter Keterangan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="radiolist" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" >
                                                <?php echo $data['KETERANGAN']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                        </div>
                                    </div>
                                    <a class="btn btn-sm btn-info"  href="<?php print_link("dhkap/edit1/$rec_id"); ?>">
                                        <i class="fa fa-edit"></i> Edit
                                    </a>
                                </div>
                                <?php
                                }
                                else{
                                ?>
                                <!-- Empty Record Message -->
                                <div class="text-muted p-3">
                                    <i class="fa fa-ban"></i> No Record Found
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
